Index Terms

1 Introduction

2 Background and Motivation

2.1 Useful Terms and Concepts

2.2 Challenges in Managing Branch Predictors

2.3 Classification and Overview

3 Branch Predictor Designs

3.1 Two-Level Predictors

3.2 Using Both Global History and Branch Address

3.3 Using Multiple Indexing Functions

3.4 Leveraging Biased Branches

3.5 Geometric History Length Branch Predictors

4 Branch Predictors for Hard-to-Predict Branches

4.1 Predicting Loop-Exit Branches

4.2 Predicting Branches Inside Nested Loops

4.3 Predicting Branches with Long Period

4.4 Predicting Based on Data Correlation

4.5 Predicting Based on Address Correlation

5 Hybrid Branch Predictors

5.1 Tagged Hybrid Branch Predictors

5.2 Selection-Based Hybrid Branch Predictors

5.3 Fusion-Based Hybrid Branch Predictors

5.4 Multi-Hybrid Branch Predictor Designs

5.5 Prophet-Critic Hybrid Branch Predictor

6 Techniques for Improving Branch Predictor Accuracy

6.1 Adapting History-Length and Path-Length

6.2 Filtering Branch History

6.3 Reducing Aliasing with Kernel-Mode Instructions

6.4 Using Conflict-Reducing Indexing Functions

6.5 Handling Multithreading and Short Threads

6.6 Utilizing Information from Wrong-Path Execution

7 Neural Branch Predictors and Implementation Techniques

7.1 Neural Branch Predictors

7.2 Optimizing Neural Branch Predictors

7.3 Analog Implementations of Neural Branch Predictors

8 Techniques for Reducing Branch Predictor Latency and Energy

8.1 Branch Predictor Pipelining

8.2 Branch Predictor Caching and Overriding

8.3 Branch Predictor Virtualization

8.4 Predicting Multiple Branches in Each Cycle

8.5 Reducing Pattern History Table Size by Branch History Register Partitioning

8.6 Leveraging Branch Locality

8.7 Avoiding Redundant Reads and Updates

9 Conclusion and Future Outlook